#include <stdio.h>
#include <string.h>

#include "parser.h"
#include "sgrep_data.h"

int parse(int arguments, char **args, sgrep_data *data) {

  if (arguments == 0)
    {
      return PARSE_BAD_INDATA;
    }
  else if (arguments >= 4)
    {
      return PARSE_BAD_INDATA;
    }
  
  int i;
  for (i = 0; i < arguments; i++) {
    
     if (args[i] == NULL)
       return PARSE_BAD_INDATA;
     
     /* printf ("Argument: %s\n", args[i]); */
  }
  
  /* Default values */
   data->reg_exp          = NULL;
   data->line_number_mode = 0;
   data->line_count       = 0;
   data->match_count      = 0;
   data->count_mode       = 0;
   data->case_sensitive   = 1; /* set case INsensitive as default */
   data->in               = stdin;
   
   
   
   if (strcmp("-i", args[0]) == 0) 
     {
       data->case_sensitive = 0; /* set case insensitive */
     }
   else if (strcmp("-c", args[0]) == 0) 
     {
       data->count_mode = 1; /* count hits */
     }
   else if (strcmp("-n", args[0]) == 0) 
     {
       data->line_number_mode = 1; /* prepend line no. */
     }
   else 
     {
       data->reg_exp = args[0];
     }   
  


   
   
  if (data->reg_exp == NULL)
    {
      /* printf("reg_exp NULL\n");       */
  
      if (arguments == 1)
	return PARSE_BAD_INDATA;

      else if (arguments > 1)
	data->reg_exp = args[1];
    
      
      if (arguments == 3)
	data->in = fopen(args[2], "r");
    }
  
  
  else if (arguments == 2)
    {
      data->in = fopen(args[1], "r");
    }
  else if (arguments == 3)
    data->in = fopen(args[2], "r");

  
  if (data->in == NULL)
    {
      return PARSER_MISSING_FILE;
    }
  

  return PARSE_OK;
}


